<?php
/**
 * Copyright 2007-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 *
 * @author Jan Zagar <jan.zagar@siol.net>
 */

require_once __DIR__ . '/lib/Application.php';
Horde_Registry::appInit('ansel');

$vars = Horde_Variables::getDefaultVariables();
try {
    $gallery = $GLOBALS['injector']->getInstance('Ansel_Storage')->getGallery($vars->get('gallery'));
} catch (Ansel_Exception $e) {
    $notification->push($gallery->getMessage());
    Horde::url('view.php?view=List', true)->redirect();
    exit;
}
$form = new Horde_Form($vars, _("Content Disclaimer"), 'disclaimer');
$form->addVariable($gallery->get('name'), 'name', 'description', false);
$form->addVariable($gallery->get('desc'), 'desc', 'description', false);
$form->addHidden('', 'url', 'text', true);
$form->addHidden('', 'gallery', 'int', true);
$msg = sprintf(_("Photo content may be offensive. You must be over %d to continue."), $gallery->get('age'));
$form->addVariable($msg, 'warning', 'description', false);
$form->setButtons(array(sprintf(_("Continue - I'm over %d"), $gallery->get('age')), _("Cancel")));

if ($form->isSubmitted()) {
    if (Horde_Util::getFormData('submitbutton') == _("Cancel") ||
        !($url = Horde::verifySignedUrl($vars->get('url')))) {
        $notification->push("You are not authorised to view this photo.", 'horde.warning');
        Horde::url('view.php?view=List', true)->redirect();
        exit;
    } else {
        $session->set('ansel', 'user_age', (int)$gallery->get('age'));
        $url = new Horde_Url($url);
        $url->redirect();
        exit;
    }
}

$page_output->header();
$notification->notify(array('listeners' => 'status'));
$form->renderActive(null, null, null, 'post');
$page_output->footer();
