<?php
/**
 * Copyright 2010-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @author   Michael Slusarz <slusarz@horde.org>
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package  Cache
 */

/**
 * Cache storage in PHP memory.
 *
 * It persists only during a script run and ignores the object lifetime
 * because of that.
 *
 * @author    Gunnar Wrobel <wrobel@pardus.de>
 * @author    Michael Slusarz <slusarz@horde.org>
 * @category  Horde
 * @copyright 2010-2017 Horde LLC
 * @license   http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package   Cache
 * @since     2.5.0
 */
class Horde_Cache_Storage_Memory extends Horde_Cache_Storage_Base
{
    /**
     * Storage for this cache.
     *
     * @var array
     */
    private $_cache = array();

    /**
     */
    public function get($key, $lifetime = 0)
    {
        return isset($this->_cache[$key])
            ? $this->_cache[$key]
            : false;
    }

    /**
     */
    public function set($key, $data, $lifetime = 0)
    {
        $this->_cache[$key] = $data;
    }

    /**
     */
    public function exists($key, $lifetime = 0)
    {
        return isset($this->_cache[$key]);
    }

    /**
     */
    public function expire($key)
    {
        unset($this->_cache[$key]);
    }

    /**
     */
    public function clear()
    {
        $this->_cache = array();
    }

}
