<?php
/**
 * The id part of the GUID of this object.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */

/**
 * The id part of the GUID of this object.
 *
 * Copyright 2008-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */
class Horde_Kolab_Server_Object_Attribute_Id
extends Horde_Kolab_Server_Object_Attribute_External
{
    /**
     * Constructor
     *
     * @param Horde_Kolab_Server_Object    $object    The object this attribute
     *                                                belongs to.
     * @param Horde_Kolab_Server_Composite $composite The link to the server.
     */
    public function __construct(
        Horde_Kolab_Server_Object $object,
        Horde_Kolab_Server_Composite $composite
    ) {
        parent::__construct($object, $composite, 'Id');
    }

    /**
     * Return the value of this attribute.
     *
     * @return array The value(s) of this attribute.
     */
    public function value()
    {
        $guid = $this->_object->getGuid();
        $base = $this->_composite->server->getBaseUid();
        return substr($guid, 0, strlen($guid) - strlen($base) - 1);
    }
}