<?php
/**
 * Return all KolabInetOrgPersons with the given mail or alias address.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */

/**
 * Return all KolabInetOrgPersons with the given mail or alias address.
 *
 * Copyright 2008-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */
class Horde_Kolab_Server_Search_Operation_Guidformailoralias
extends Horde_Kolab_Server_Search_Operation_Restrictkolab
{
    /**
     * Return all KolabInetOrgPersons with the given mail or alias address.
     *
     * @param string $mail  The mail address to search for.
     * @param string $alias The alias address to search for.
     *
     * @return array The GUID(s).
     *
     * @throws Horde_Kolab_Server_Exception
     */
    public function searchGuidForMailOrAlias($mail, $alias)
    {
        $criteria = new Horde_Kolab_Server_Query_Element_Or(
            new Horde_Kolab_Server_Query_Element_Equals(
                'Mail', $mail
            ),
            new Horde_Kolab_Server_Query_Element_Equals(
                'Alias', $alias
            )
        );
        return parent::searchRestrictKolab($criteria);
    }
}